/*
In the last tutorial, we learnt how to add Properties to a Station. Now let's see how
we can remove the device network...

- Once again, 'Drivers' is a subscribed Proxy Component. 
- Calling 'remove' results in an asynchronous network call.
- As the network call is asynchronous, an ok function is supplied as an argument. The ok function is called once the network call has successfully completed!
- Optionally, a fail function can be used to define an error scenario for the remove.
*/

var deviceNetworkName = baja.SlotPath.escape("BsModbusNetwork");

baja.Ord.make("station:|slot:/Drivers").get({
  ok: function (drivers) {
    // Only add the driver if it doesn't already exist!
    if (drivers.has(deviceNetworkName)) {
      drivers.remove({
        slot: deviceNetworkName,
        ok: function () {
          baja.outln("Removed the device network!");
        },
        fail: function (err) {
          baja.outln("Called if error removing!");
        }
      });
    }
    else {
      baja.outln("Device network already removed!");
    }
  },
  lease: true
});

// Note that if other students are also going through this tutorial on this Station right now, then you may see some unexpected results!
